/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIHSCSysProfClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIRemoveSystemConfiguration {
    private static final int NUM_VALID_PARMS = 5;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_resourceName;
    private String m_sourcePartitionName;
    private String m_partitionID;
    private HashMap m_validParms = new HashMap(11, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIRemoveSystemConfiguration(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-n", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("--id", null);
    }

    private void doPartitionRemove() throws PIHscClientException {
        String string = this.constructPartName();
        this.m_CECClient.deletePartition(string);
    }

    private String constructPartName() {
        String string = null;
        String string2 = null;
        try {
            string2 = this.m_CECClient.getIntName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.m_partitionID != null) {
            string = this.m_partitionID + "*" + string2;
        }
        if (this.m_resourceName != null) {
            try {
                Vector vector = this.m_CECClient.getPartitionNames();
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray = (String[])vector.elementAt(i);
                    if (stringArray == null || !stringArray[1].equals(this.m_resourceName)) continue;
                    string = stringArray[0];
                    break;
                }
            }
            catch (PIHscClientException pIHscClientException) {
                pIHscClientException.printStackTrace(this.m_out);
            }
        }
        return string;
    }

    private void doProfileRemove() throws PIHscClientException {
        PIHSCLPARClient pIHSCLPARClient = null;
        pIHSCLPARClient = this.m_sourcePartitionName != null ? this.m_factory.createLPARClient(this.m_managedSystem, this.m_sourcePartitionName, false) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionID, true);
        if (pIHSCLPARClient == null) {
            if (this.m_partitionID != null) {
                String[] stringArray = new String[]{this.m_partitionID};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray);
            }
            String[] stringArray = new String[]{this.m_sourcePartitionName};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray);
        }
        pIHSCLPARClient.deleteProfile(this.m_resourceName);
    }

    private void doSysProfRemove() throws PIHscClientException {
        PIHSCSysProfClient pIHSCSysProfClient = null;
        pIHSCSysProfClient = this.m_factory.createSysProfClient(this.m_CECClient, this.m_resourceName);
        if (pIHSCSysProfClient == null) {
            String[] stringArray = new String[]{this.m_resourceName};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8010", stringArray, null);
        }
        pIHSCSysProfClient.deleteSysProf();
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if ("lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType)) {
            if (n != 17 && n != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
            }
        } else {
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
            if (n == 251 || n == 253) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
            }
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        if ("lpar".equals(this.m_resourceType)) {
            this.doPartitionRemove();
        } else if ("prof".equals(this.m_resourceType)) {
            this.doProfileRemove();
        } else {
            this.doSysProfRemove();
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        if (this.m_resourceType == null || !"lpar".equals(this.m_resourceType) && !"prof".equals(this.m_resourceType) && !"sysprof".equals(this.m_resourceType)) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = "-m";
        }
        if ("lpar".equals(this.m_resourceType)) {
            if (!(this.m_resourceName != null && this.m_resourceName.length() != 0 || this.m_partitionID != null && this.m_partitionID.length() != 0)) {
                string = string + ", -n | --id";
            }
        } else {
            if (this.m_resourceName == null || this.m_resourceName.length() == 0) {
                string = string + ", -n";
            }
            if (!(!"prof".equals(this.m_resourceType) || this.m_sourcePartitionName != null && this.m_sourcePartitionName.length() != 0 || this.m_partitionID != null && this.m_partitionID.length() != 0)) {
                string = string + ", -p | --id";
            }
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ("lpar".equals(this.m_resourceType)) {
            if (this.m_resourceName != null && this.m_partitionID != null) {
                string = "[-n | --id]";
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
            }
            if (this.m_sourcePartitionName != null) {
                String[] stringArray = new String[]{"-p", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
        } else if ("prof".equals(this.m_resourceType) && this.m_sourcePartitionName != null && this.m_partitionID != null) {
            string = "[-p | --id]";
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        if ("sysprof".equals(this.m_resourceType) && (this.m_sourcePartitionName != null || this.m_partitionID != null)) {
            string = this.m_sourcePartitionName != null && this.m_partitionID != null ? "-p, --id" : (this.m_sourcePartitionName != null ? "-p" : "--id");
            String[] stringArray = new String[]{string, this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_resourceName = (String)hashMap.get("-n");
        this.m_sourcePartitionName = (String)hashMap.get("-p");
        this.m_partitionID = (String)hashMap.get("--id");
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        if ("sys".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_RMSYSCFG_SYS_TYPE", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "RMSYSCFG_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIRemoveSystemConfiguration pIRemoveSystemConfiguration = new PIRemoveSystemConfiguration(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIRemoveSystemConfiguration.m_validParms);
            pIRemoveSystemConfiguration.mapParameters(hashMap);
            pIRemoveSystemConfiguration.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string;
                if ("lpar".equals(pIRemoveSystemConfiguration.m_resourceType)) {
                    if (pIRemoveSystemConfiguration.m_resourceName != null) {
                        Object[] objectArray = new String[]{pIRemoveSystemConfiguration.m_resourceName};
                        string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "DELETE_PARTITION_NAME_ERROR", "", objectArray);
                    } else {
                        Object[] objectArray = new String[]{pIRemoveSystemConfiguration.m_partitionID};
                        string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "DELETE_PARTITION_ID_ERROR", "", objectArray);
                    }
                } else if ("prof".equals(pIRemoveSystemConfiguration.m_resourceType)) {
                    Object[] objectArray = new String[]{pIRemoveSystemConfiguration.m_resourceName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "DELETE_PROF_ERROR", "", objectArray);
                } else {
                    Object[] objectArray = new String[]{pIRemoveSystemConfiguration.m_resourceName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "DELETE_SYS_PROF_ERROR", "", objectArray);
                }
                printStream.println(string);
                string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

